import os
import pytesseract

# Set Tesseract path for Windows
try:
    pytesseract.pytesseract.tesseract_cmd = r'C:\Program Files\Tesseract-OCR\tesseract.exe'
except:
    pass  # Will use system PATH if not Windows


class Config:
    SECRET_KEY = '#@#@aDm1n#@#@'
    FREE_CONVERSION_LIMIT = 3  # Maximum free conversions per user
    FREE_PAGE_LIMIT = 5        # Maximum pages per file for free users
    PRO_CONVERSION_TYPES = {'scanned', 'custom'} # Features locked to Pro tier
    
    # MySQL Database Configuration
    MYSQL_HOST = 'localhost'
    MYSQL_PORT = 3306
    MYSQL_USER = 'root'
    MYSQL_PASSWORD = ''  # Empty password for default setup
    MYSQL_DATABASE = 'pdf_converter'
    
    SQLALCHEMY_DATABASE_URI = f'mysql+pymysql://{MYSQL_USER}:{MYSQL_PASSWORD}@{MYSQL_HOST}:{MYSQL_PORT}/{MYSQL_DATABASE}'
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    SQLALCHEMY_ECHO = False  # Set to True for SQL debugging

    # Google OAuth Configuration
    GOOGLE_CLIENT_ID = "845014211312-dlnrnjf098k15h7n7sul9bgfhk78edv3.apps.googleusercontent.com"
    GOOGLE_CLIENT_SECRET = "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"
    GOOGLE_DISCOVERY_URL = "https://accounts.google.com/.well-known/openid-configuration"
    
    UPLOAD_FOLDER = 'uploads'
    OUTPUT_FOLDER = 'outputs'
    ALLOWED_EXTENSIONS = {'pdf'}
    MAX_CONTENT_LENGTH = 5 * 1024 * 1024  # 16MB max file size

    # Replace with your actual Gemini API Key
    API_KEY = "AIzaSyD3DA8ALvpjd9RW8ivf1MDRcEgb2j0Cd8g"

    # QuickBooks Configuration (Development Mode)
    QUICKBOOKS_ENABLED = True
    QUICKBOOKS_DEVELOPMENT_MODE = True
    QUICKBOOKS_SANDBOX = True

    # Development credentials (not needed for mock service)
    QUICKBOOKS_CONSUMER_KEY = "ABdjzWJDPUQaKr9DC8hDpl4RGewKDepQsgkimh77GgTh2U6nBD"
    QUICKBOOKS_CONSUMER_SECRET = "CaLnrd3fbplzBH4gMOsoJYzznQNvl5tY7QQ0eX8N"
    QUICKBOOKS_ACCESS_TOKEN = "eyJhbGciOiJkaXIiLCJlbmMiOiJBMTI4Q0JDLUhTMjU2IiwieC5vcmciOiJIMCJ9..kWPfwXPs7ioWacIHx1moWg.6J48H69cR2dAcdefsbOJILPcT0tnqCiveq4vUpI1ZWOsUvRzcddeQM3kyQMq3iYRjDQgJXDxURC2eVGO_cVBDHT_xRr9hC8ZjDU6s4C74EWgfk9unnk_LgQ9gMtTX1acpqiWhxCC3NYi4dcbkEWdFllq-LsfNlJ3dAvwhtxheKb15XmAOk1hpiSdM-oXADZ3tsXSVjkUi_MpSGWSfHIy-HsoUowlPIzefuOgzy86rk-ipykjAUkgRXRapAt9VX06Zs-hVBDWQ-yMW6htcfvlQS6B0gHbN-yXcGzhxJoNu9LJkoTe_O-yDrO_CmgG9cFpYPTBWRZ0sutEhsTvnAX7qUprtVAFZvzJwPRF9GTMMrEw9DAB3nK5M92nyp1MQHRc9nkRV-8K6MLy_HSZ0Wq_P02q-21aw8LPWir-A5tRXyOTBIfOfc--lgrkHfyDodWTpclEI3PtlLGz0pJEDz0xHBRT0vn719Vkb5f-DGeO8o3x6NZFM0A2KgS3pMUcF3ILZpxC9edCryhrJY5AV7Op7v6eZWXw6cv8ag8oIKFDyYBsR79811lDDqodMHJoex57rlWiV-MDgIJ1fGhVMFbM5CwnSmVV5LvOhjK221Avl9BdcjG4667rKxLkaXVk8XKq.wDUQnASdCu4SVZlBjoHKKw"
    QUICKBOOKS_ACCESS_TOKEN_SECRET = "RT1-246-H0-1771175113ru1ax6zsyzzbx5d0gqp3"
    QUICKBOOKS_COMPANY_ID = "9341455649885282"

    # QuickBooks OAuth 2.0 Configuration
    QB_CLIENT_ID = "ABdjzWJDPUQaKr9DC8hDpl4RGewKDepQsgkimh77GgTh2U6nBD"
    QB_CLIENT_SECRET = "CaLnrd3fbplzBH4gMOsoJYzznQNvl5tY7QQ0eX8N"
    QB_REDIRECT_URI = "http://localhost:5000/quickbooks/callback"
    QB_ENVIRONMENT = "sandbox"  # or "production